<?php
/**
 * Plugin Name: Card2Crypto.org Global Payment Gateway with Instant Payouts
 * Plugin URI: https://card2crypto.org/woocommerce-international-card-payment-gateway/
 * Description: Accept domestic and international credit/debit cards, Apple Pay, Google Pay, SEPA, and local bank transfers directly to your USDC Polygon (Crypto) wallet with instant settlement and chargeback protection. Experience the Web 3.0 revolution with no KYC or sign-up required.
 * Version: 1.3.1
 * Requires Plugins: woocommerce
 * Requires at least: 5.8
 * Tested up to: 6.9
 * WC requires at least: 5.8
 * WC tested up to: 10.3.6
 * Requires PHP: 7.2
 * Author: card2crypto.org
 * Author URI: https://card2crypto.org/
 * License: GPLv3
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */

    // Exit if accessed directly.
    if (!defined('ABSPATH')) {
        exit;
    }

    add_action('before_woocommerce_init', function() {
        if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
            \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
        }
    });
	
	add_action( 'before_woocommerce_init', function() {
    if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'cart_checkout_blocks', __FILE__, true );
    }
} );

/**
 * Enqueue block assets for the gateway.
 */
function card2cryptogateway_enqueue_block_assets() {
    // Fetch all enabled WooCommerce payment gateways
    $card2cryptogateway_available_gateways = WC()->payment_gateways()->get_available_payment_gateways();
    $card2cryptogateway_gateways_data = array();

    foreach ($card2cryptogateway_available_gateways as $gateway_id => $gateway) {
		if (strpos($gateway_id, 'card2crypto') === 0) {
        $icon_url = method_exists($gateway, 'card2crypto_instant_payment_gateway_get_icon_url') ? $gateway->card2crypto_instant_payment_gateway_get_icon_url() : '';
        $card2cryptogateway_gateways_data[] = array(
            'id' => sanitize_key($gateway_id),
            'label' => sanitize_text_field($gateway->get_title()),
            'description' => wp_kses_post($gateway->get_description()),
            'icon_url' => sanitize_url($icon_url),
        );
		}
    }

    wp_enqueue_script(
        'card2cryptogateway-block-support',
        plugin_dir_url(__FILE__) . 'assets/js/card2cryptogateway-block-checkout-support.js',
        array('wc-blocks-registry', 'wp-element', 'wp-i18n', 'wp-components', 'wp-blocks', 'wp-editor'),
        filemtime(plugin_dir_path(__FILE__) . 'assets/js/card2cryptogateway-block-checkout-support.js'),
        true
    );

    // Localize script with gateway data
    wp_localize_script(
        'card2cryptogateway-block-support',
        'card2cryptogatewayData',
        $card2cryptogateway_gateways_data
    );
}
add_action('enqueue_block_assets', 'card2cryptogateway_enqueue_block_assets');

/**
 * Enqueue styles for the gateway on checkout page.
 */
function card2cryptogateway_enqueue_styles() {
    if (is_checkout()) {
        wp_enqueue_style(
            'card2cryptogateway-styles',
            plugin_dir_url(__FILE__) . 'assets/css/card2cryptogateway-payment-gateway-styles.css',
            array(),
            filemtime(plugin_dir_path(__FILE__) . 'assets/css/card2cryptogateway-payment-gateway-styles.css')
        );
    }
}
add_action('wp_enqueue_scripts', 'card2cryptogateway_enqueue_styles');

    include_once(plugin_dir_path(__FILE__) . 'includes/class-smart-card2crypto-hosted.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-revolut.php'); // Include the payment gateway class	
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-stripe.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-rampnetwork.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-transak.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-moonpay.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-banxa.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-guardarian.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-utorg.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-transfi.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-sardine.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-kryptonim.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-topper.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-cryptix.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-unlimit.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-bitnovo.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-robinhood.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-upi.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-interac.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-simplex.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-binance.php'); // Include the payment gateway class
	include_once(plugin_dir_path(__FILE__) . 'includes/class-card2crypto-customprovider.php'); // Include the payment gateway class

	// Conditional function that check if Checkout page use Checkout Blocks
function card2cryptogateway_is_checkout_block() {
    return WC_Blocks_Utils::has_block_in_page( wc_get_page_id('checkout'), 'woocommerce/checkout' );
}

function card2cryptogateway_add_notice($card2cryptogateway_message, $card2cryptogateway_notice_type = 'error') {
    // Check if the Checkout page is using Checkout Blocks
    if (card2cryptogateway_is_checkout_block()) {
        // For blocks, throw a WooCommerce exception
        if ($card2cryptogateway_notice_type === 'error') {
            throw new \WC_Data_Exception('checkout_error', esc_html($card2cryptogateway_message)); 
        }
        // Handle other notice types if needed
    } else {
        // Default WooCommerce behavior
        wc_add_notice(esc_html($card2cryptogateway_message), $card2cryptogateway_notice_type); 
    }
}	
	
?>